//
//  MCBasePhoneFormatter.h
//  MCFoundation
//
//  Created by Ali Lalani on Thu Aug 15 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCStringFormatter.h"


@interface MCBasePhoneFormatter : MCStringFormatter {
    NSString *phCharSetString;
    NSCharacterSet *phCharSet;
    NSCharacterSet *numericSet;
    NSArray *numArr;
    NSArray *alphArr;
    NSUserDefaults *prefs;

	// Defaults
	BOOL shouldFormat;                   // YES if the formatter should be applied, no if not
	NSArray *extensionList;              // list of all the ways they can delimit extensions
	NSString *defaultFormat;             // format to use when formatting the phone number if no format is found in UserDefaults
	NSString *stringFormat;              // format to use when formatting the phone number
	NSString *extensionSubstituteString; // a string of possible extension denoters(ext,etc...) separated by commas
	NSArray *extensionArray;

	// Phone number elements
	NSString *exchange;
	NSString *number;
	NSString *areaCode;
	NSString *prefix;
	NSString *extension;
	BOOL isNorthAmerican;
	
    // Options
    BOOL parenthesesAroundAreaCode;
    BOOL convertLettersToNumbers;
    BOOL allowExtensions;
	BOOL ignoreAutoFormatUserDefault;
}

- (NSString *)getNumberForLetter:(NSString *)theLetter;
- (NSString *)formatString:(NSString *)rawString;
- (NSString *)parseString:(NSString *)theString;
- (NSString *)formStringWithPrefix:(NSString *)thePrefix areaCode:(NSString *)theAreaCode
												  exchange:(NSString *)theExchange number:(NSString *)theNumber extension:(NSString *)theExtention;

- (BOOL)squashChar:(NSString *)theChar inString:(NSString **)theString;
- (void)setParenthesesAroundAreaCode:(BOOL)choice;
- (void)setConvertLettersToNumbers:(BOOL)choice;
- (void)setAllowExtensions:(BOOL)choice;
- (void)commonInit;
- (NSString *)stringFormat;
- (void)setStringFormat:(NSString *)theFormat;
- (BOOL)parenthesesAroundAreaCode;
- (BOOL)convertLettersToNumbers;
- (BOOL)allowExtensions;
- (BOOL)isNorthAmerican;
- (void)setIsNorthAmerican:(BOOL)choice;
- (NSArray *)extensionArray;
- (NSString *)extension;
- (NSString *)exchange;
- (NSString *)number;
- (NSString *)prefix;
- (NSString *)areaCode;
- (void)setExtension:(NSString *)theExtension;
- (void)setExchange:(NSString *)theExchange;
- (void)setNumber:(NSString *)theNumber;
- (void)setPrefix:(NSString *)thePrefix;
- (void)setAreaCode:(NSString *)theAreaCode;
- (BOOL)ignoreAutoFormatUserDefault;
- (void)setIgnoreAutoFormatUserDefault:(BOOL)flag;
@end
